<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if ( ! class_exists( 'MTS_Testimonials_Shortcodes' ) ) :

class MTS_Testimonials_Shortcodes extends MTS_Testimonials {

	function __construct() {
		add_action( 'init', array( $this, 'init' ) );

		add_shortcode( 'mts_testimonial_form', array( $this, 'testimonial_form' ) );
		add_shortcode( 'mts_testimonial', array( $this, 'testimonial_shortcode' ) );
	}

	function init() {
		// Process front-end testimonial form
		if ( isset( $_POST['submit_testimonial'] ) && wp_verify_nonce( $_POST['testimonial_nonce'], 'testimonial_form' ) ) {
			global $testimonial_form_messages;

			$settings = mts_testimonials_get_settings();

			if ( isset( $_POST['title'] ) )
				$args['title'] = esc_attr( $_POST['title'] );

			if ( isset( $_POST['person_name'] ) )
				$args['name'] = esc_attr( $_POST['person_name'] );

			if ( isset( $_POST['position'] ) )
				$args['position'] = esc_attr( $_POST['position'] );

			if ( isset( $_POST['link'] ) ) {
				if ( !filter_var( $_POST['link'], FILTER_VALIDATE_URL ) ) :
					$testimonial_form_messages['error'][] = sprintf( __('Invalid %s address', 'mts-testimonials'), strtolower( $settings['forms']['testimonial_form']['link_field_label'] ) );
				else :
					$args['link'] = esc_url( $_POST['link'] );
				endif;
			}

			if ( isset( $_POST['email'] ) ) {
				if ( !filter_var( $_POST['email'], FILTER_VALIDATE_EMAIL ) ) :
					$testimonial_form_messages['error'][] = sprintf( __('Invalid %s address', 'mts-testimonials'), strtolower( $settings['forms']['testimonial_form']['email_field_label'] ) );
				else :
					$args['email'] = esc_attr( $_POST['email'] );
				endif;
			}

			if ( isset( $_POST['rating'] ) ) {
				if (empty($_POST['rating'])) {
					$testimonial_form_messages['error'][] = __('Please select a rating', 'mts-testimonials');
				} else {
					$args['rating'] = (int) $_POST['rating'];
				}

			}
			if ( isset( $_POST['testimonial'] ) )
				$args['testimonial'] = esc_attr( strip_tags( $_POST['testimonial'] ) );

			if ( isset( $_FILES['image'] )
				&& ! is_array( $testimonial_form_messages['error'] )
				&& !empty ( $_FILES['image']['name'] )
				&& isset($_POST['mts_testimonial_image_upload'])
				&& wp_verify_nonce( $_POST['mts_testimonial_image_upload'], 'mts_testimonial_image_upload' )
				&& $_FILES['image']['error'] === UPLOAD_ERR_OK ) {

				if ($_FILES['image']['size'] > $settings['general']['max_image_size'] * 1024 * 1024) {
					$testimonial_form_messages['error'][] = sprintf( __('Uploaded image is too large. Max filesize: %d MB', 'mts-testimonials'), $settings['general']['max_image_size'] );
				}

				$uploadedfile = $_FILES['image'];
				$uploaded_name = $_FILES['image']['name'];
				$allowed_file_types = array('jpg' =>'image/jpg','jpeg' =>'image/jpeg', 'gif' => 'image/gif', 'png' => 'image/png');
				$upload_overrides = array( 'test_form' => false, 'mimes' => $allowed_file_types );

				// make sure these are loaded to use media_handle_upload()
				include_once ABSPATH . 'wp-admin/includes/media.php';
				include_once ABSPATH . 'wp-admin/includes/file.php';
				include_once ABSPATH . 'wp-admin/includes/image.php';

				$upload_id = media_handle_upload( 'image', 0, array(), $upload_overrides );
				if (!is_wp_error( $upload_id )) {
					//$args['image'] = $upload['url'];
					$args['info'] = wp_get_attachment_image_src( $upload_id, 'medium' );
					$args['image'] = $args['info'][0];
				}
			}

			if ( ! is_array( $testimonial_form_messages['error'] ) ) :
				if ( !empty( $args ) ) :
					$add_testimonial = $this->add_testimonial( $args );
				else :
					$add_testimonial = false;
				endif;
			else :
				$add_testimonial = false;
			endif;

			// Display message
			if ( $add_testimonial ) {
				$testimonial_form_messages['success'] = $settings['forms']['testimonial_form']['success_message'];
			} else {
				$testimonial_form_messages['error'][] = $settings['forms']['testimonial_form']['error_message'];
			}
		}
	}

	/**
     * Front-end testimonial form shortcode
	 *
     * @param array $atts
     */
	function testimonial_form( $atts ) {
		global $testimonial_form_messages, $mts_testimonials;

		$settings = mts_testimonials_get_settings();

		$nonce = wp_create_nonce( 'testimonial_form' );

		$output = '<div id="mts-testimonials">';

		// Display messages
		if ( is_array( $testimonial_form_messages ) ) {
			if ( @$testimonial_form_messages['success'] ) {
				$output .= "<div class=\"mts-success\">". $testimonial_form_messages['success'] ."</div>";
				$output .= '</div>';
				return $output;
			} else if ( $testimonial_form_messages['error'] ) {
				$output .= "<div class=\"mts-error\">";
				foreach( $testimonial_form_messages['error'] as $k => $message ) {
					$output .= $message . "<br />\r\n";
				}
				$output .= "</div>";
			}
		}

		$output .= "<form action=\"\" method=\"post\" enctype=\"multipart/form-data\" id=\"mts-testimonial-submit-form\">";

		if ( (int) $settings['forms']['testimonial_form']['title_field_checkbox'] ) {
			$output .= '<div class="mts-testimonial-field mts-testimonial-field-title">';
			$output .= "<label for=\"title\">". $settings['forms']['testimonial_form']['title_field_label'] ."</label><br />";
			$val = (!empty($_POST['title']) ? esc_attr($_POST['title']) : '');
			$output .= "<input type=\"text\" name=\"title\" id=\"title\" value=\"{$val}\">";
			$output .= '</div>';
		}

		if ( (int) $settings['forms']['testimonial_form']['name_field_checkbox'] ) {
			$output .= '<div class="mts-testimonial-field mts-testimonial-field-name">';
			$output .= "<label for=\"name\">". $settings['forms']['testimonial_form']['name_field_label'] ."</label><br />";
			$val = (!empty($_POST['person_name']) ? esc_attr($_POST['person_name']) : '');
			$output .= "<input type=\"text\" name=\"person_name\" id=\"name\" value=\"{$val}\">";
			$output .= '</div>';
		}

		if ( (int) $settings['forms']['testimonial_form']['position_checkbox'] ) {
			$output .= '<div class="mts-testimonial-field mts-testimonial-field-position">';
			$output .= "<label for=\"position\">". $settings['forms']['testimonial_form']['position_field_label'] ."</label><br />";
			$val = (!empty($_POST['position']) ? esc_attr($_POST['position']) : '');
			$output .= "<input type=\"text\" name=\"position\" id=\"position\" value=\"{$val}\">";
			$output .= '</div>';
		}

		if ( (int) $settings['forms']['testimonial_form']['link_field_checkbox'] ) {
			$output .= '<div class="mts-testimonial-field mts-testimonial-field-link">';
			$output .= "<label for=\"link\">". $settings['forms']['testimonial_form']['link_field_label'] ."</label><br />";
			$val = (!empty($_POST['link']) ? esc_url($_POST['link']) : '');
			$output .= "<input type=\"text\" name=\"link\" id=\"link\" value=\"{$val}\">";
			$output .= '</div>';
		}

		if ( (int) $settings['forms']['testimonial_form']['email_field_checkbox'] ) {
			$output .= '<div class="mts-testimonial-field mts-testimonial-field-email">';
			$output .= "<label for=\"email\">". $settings['forms']['testimonial_form']['email_field_label'] ."</label><br />";
			$val = (!empty($_POST['email']) ? esc_attr($_POST['email']) : '');
			$output .= "<input type=\"text\" name=\"email\" id=\"email\" value=\"{$val}\">";
			$output .= '</div>';
		}

		if ( (int) $settings['forms']['testimonial_form']['image_field_checkbox'] ) {
			$output .= '<div class="mts-testimonial-field mts-testimonial-field-image">';
			$output .= "<label for=\"image\">". $settings['forms']['testimonial_form']['image_field_label'] ."</label><br />";
			$output .= "<input type=\"file\" name=\"image\" id=\"image\"><br />";
			$output .= wp_nonce_field( 'mts_testimonial_image_upload', 'mts_testimonial_image_upload', true, false );
			$output .= '</div>';
		}

		if ( (int) $settings['forms']['testimonial_form']['rating_field_checkbox'] ) {
			$output .= '<div class="mts-testimonial-field mts-testimonial-field-rating">';
			$output .= "<label for=\"rating\">". $settings['forms']['testimonial_form']['rating_field_label'] ."</label><br />";

			$val = (!empty($_POST['rating']) ? (int) $_POST['rating'] : 0);
			$output .= $mts_testimonials->stars_input('rating', $val, 'mts-testimonial-rating');
			$output .= '</div>';
		}

		if ( (int) $settings['forms']['testimonial_form']['testimonial_field_checkbox'] ) {
			$output .= '<div class="mts-testimonial-field mts-testimonial-field-testimonial">';
			$output .= "<label for=\"testimonial\">". $settings['forms']['testimonial_form']['testimonial_field_label'] ."</label><br />";
			$val = (!empty($_POST['testimonial']) ? esc_textarea($_POST['testimonial']) : '');
			$output .= "<textarea name=\"testimonial\" id=\"testimonial\" rows=\"4\" cols=\"50\">{$val}</textarea>";
			$output .= '</div>';
		}

		$output .= "<input type=\"hidden\" name=\"testimonial_nonce\" value=\"". $nonce ."\" />";

		$output .= "<input type=\"submit\" name=\"submit_testimonial\" id=\"submit_testimonial\" class=\"submit\" value=\"". $settings['forms']['testimonial_form']['submit_label'] . "\" />";
		$output .= "</form></div>";

		return $output;
	}

	/**
	 * The main shortcode to display testimonial
	 *
	 * @param array $atts
	 * @return string
	 */
	function testimonial_shortcode( $atts ) {
		$attribute = shortcode_atts( array(
			'testimonials' => '',
			'category' => '',
			'number' => '3',
			'order_by' => 'rand',
			'layout' => 'bubble_grid',
			'color_scheme' => '',
			'show_title' => 1,
			'show_image' => 1,
			'show_position' => 1,
			'show_rating' => 1,
			'carousel_transition' => 3,
		), $atts );
		if (empty($attribute['number']))
			$attribute['number'] = 3;

		$settings = mts_testimonials_get_settings();
		$testimonial_ids = array();
		if (!empty($attribute['testimonials'])) $testimonial_ids = explode(',', $attribute['testimonials']);
		$testimonial_query = mts_get_testimonial( (int) $attribute['number'], $attribute['category'], 'publish', $attribute['order_by'], $testimonial_ids );

		$output = '';
		$i = 0;
		$args = array();
		foreach( $testimonial_query as $post ) {
			// Setup testimonial arguments
			$title = get_the_title( $post->ID ); //get_post_meta( $post->ID, 'testimonial_title', true );
			$name = get_post_meta( $post->ID, 'testimonial_name', true );
			$position = get_post_meta( $post->ID, 'testimonial_position', true );
			$link = get_post_meta( $post->ID, 'testimonial_link', true );
			$email = get_post_meta( $post->ID, 'testimonial_email', true );
			$image = get_post_meta( $post->ID, 'testimonial_image', true );
			if (empty($image)) {
				$image = $settings['general']['default_image'];
			}
			$rating = get_post_meta( $post->ID, 'testimonial_rating', true );
			$testimonial_content = $post->post_content;

			$args['posts'][$i]['title'] =  esc_attr( $title );
			$args['posts'][$i]['name'] =  esc_attr( $name );
			$args['posts'][$i]['position'] =  esc_attr( $position );
			$args['posts'][$i]['link'] =  esc_url( $link );
			$args['posts'][$i]['email'] =  esc_attr( $email );
			$args['posts'][$i]['image'] =  esc_url( $image );
			$args['posts'][$i]['rating'] =  (int) $rating;
			$args['posts'][$i]['testimonial'] = esc_attr( $testimonial_content );
			$args['posts'][$i]['id'] = (int) $post->ID;

			$i++;
		}

		$args['layout'] = esc_attr( $attribute['layout'] );
		$args['color_scheme'] = esc_attr( $attribute['color_scheme'] );
		$args['show_title'] = (int) $attribute['show_title'];
		$args['show_image'] = (int) $attribute['show_image'];
		$args['show_position'] = (int) $attribute['show_position'];
		$args['show_rating'] = (int) $attribute['show_rating'];
		$args['carousel_transition'] = (int) $attribute['carousel_transition'] * 1000;

		$output .= mts_get_testimonial_layout( $args );

		return '<div id="mts-testimonials">'.$output.'</div>';
	}

}

endif;
